<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->
<?php
    $rootFolder = basename($_SERVER['DOCUMENT_ROOT']);
    $baseUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . str_replace('/pages', '', dirname($_SERVER['SCRIPT_NAME']));
?>
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->

<!-- This code is useful for internal styles  -->
<?php ob_start(); ?>

        <!-- FILEPOND CSS -->
        <link rel="stylesheet" href="<?php echo $baseUrl; ?>/assets/libs/filepond/filepond.min.css">
        <link rel="stylesheet" href="<?php echo $baseUrl; ?>/assets/libs/filepond-plugin-image-preview/filepond-plugin-image-preview.min.css">
        <link rel="stylesheet" href="<?php echo $baseUrl; ?>/assets/libs/filepond-plugin-image-edit/filepond-plugin-image-edit.min.css">

<?php $styles = ob_get_clean(); ?>
<!-- This code is useful for internal styles  -->

<!-- This code is useful for content -->
<?php ob_start(); ?>

                <div class="container-fluid">

                    <!-- Page Header -->
                    <div class="d-md-flex d-block align-items-center justify-content-between my-4 page-header-breadcrumb">
                        <h1 class="page-title fw-semibold fs-18 mb-0">Create NFT</h1>
                        <div class="ms-md-1 ms-0">
                            <nav>
                                <ol class="breadcrumb mb-0">
                                    <li class="breadcrumb-item"><a href="javascript:void(0);">NFT</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">Create NFT</li>
                                </ol>
                            </nav>
                        </div>
                    </div>
                    <!-- Page Header Close -->

                    <!-- Start::row -->
                    <div class="row">
                        <div class="col-xxl-9 col-xl-8">
                            <div class="card custom-card">
                                <div class="card-header">
                                    <div class="card-title">Create NFT</div>
                                </div>
                                <div class="card-body">
                                    <div class="row gy-3 justify-content-between">
                                        <div class="col-xxl-3 col-xl-12">
                                            <div class="create-nft-item">
                                                <label class="form-label">Upload NFT</label>
                                                <input type="file" class="single-fileupload" name="filepond" accept="image/png, image/jpeg, image/gif">
                                            </div>
                                        </div>
                                        <div class="col-xxl-8 col-xl-12">
                                            <div class="row gy-3">
                                                <div class="col-xl-12">
                                                    <label for="input-placeholder" class="form-label">NFT Title</label>
                                                    <input type="text" class="form-control" id="input-placeholder" placeholder="eg:Neo-Nebulae">
                                                </div>
                                                <div class="col-xl-12">
                                                    <label for="nft-description" class="form-label">NFT Description</label>
                                                    <textarea class="form-control" id="nft-description" rows="3" placeholder="Enter Description"></textarea>
                                                </div>
                                                <div class="col-xl-12">
                                                    <label for="nft-link" class="form-label">External Link</label>
                                                    <input type="text" class="form-control" id="nft-link" placeholder="External Link Here">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-12">
                                            <div class="row gy-3">
                                                <div class="col-xl-6">
                                                    <label for="nft-creator-name" class="form-label">Creator Name</label>
                                                    <input type="text" class="form-control" id="nft-creator-name" placeholder="Enter Name">
                                                </div>
                                                <div class="col-xl-6">
                                                    <label for="nft-price" class="form-label">NFT Price</label>
                                                    <input type="text" class="form-control" id="nft-price" placeholder="Enter Price">
                                                </div>
                                                <div class="col-xl-4">
                                                    <label for="nft-size" class="form-label">NFT Size</label>
                                                    <input type="text" class="form-control" id="nft-size" placeholder="Enter Size">
                                                </div>
                                                <div class="col-xl-4">
                                                    <label for="nft-royality" class="form-label">Royality</label>
                                                    <select class="form-control" data-trigger name="nft-royality" id="nft-royality">
                                                        <option value="">Choose Royalities</option>
                                                        <option value="Choice 1">Flat Royalty</option>
                                                        <option value="Choice 2">Graduated Royalty</option>
                                                        <option value="Choice 3">Tiered Royalty</option>
                                                        <option value="Choice 3">Time-Limited Royalty</option>
                                                        <option value="Choice 3">Customized Royalty</option>
                                                    </select>
                                                </div>
                                                <div class="col-xl-4">
                                                    <label for="nft-property" class="form-label">Property</label>
                                                    <input type="text" class="form-control" id="nft-property" placeholder="Enter Property">
                                                </div>
                                                <div class="col-xl-12">
                                                    <label class="form-label d-block">Method</label>
                                                    <div class="btn-group" role="group" aria-label="Basic radio toggle button group">
                                                        <input type="radio" class="btn-check" name="strap-material" id="strap1" checked="">
                                                        <label class="btn btn-sm btn-outline-primary text-default z-0" for="strap1"><i class="ti ti-tag me-1 align-middle fs-15 d-inline-block"></i>Fixed Price</label>
                                                        <input type="radio" class="btn-check" name="strap-material" id="strap2">
                                                        <label class="btn btn-sm btn-outline-primary text-default z-0" for="strap2"><i class="ti ti-users fs-15 me-1 align-middle d-inline-block"></i>Open For Bids</label>
                                                        <input type="radio" class="btn-check" name="strap-material" id="strap3">
                                                        <label class="btn btn-sm btn-outline-primary text-default z-0" for="strap3"><i class="ti ti-hourglass-low fs-15 me-1 align-middle d-inline-block"></i>Timed Auction</label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer text-end">
                                    <a href="javascript:void(0);" class="btn btn-primary btn-wave waves-effect waves-light">Create NFT</a>
                                </div>
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4">
                            <div class="card custom-card">
                                <div class="card-header">
                                    <div class="card-title">
                                        NFT Preview Here
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="card custom-card mb-0 shadow-none border">
                                        <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/18.png" class="card-img-top" alt="...">
                                        <div class="d-flex align-items-center justify-content-between nft-like-section w-100 px-3">
                                            <div class="flex-fill">
                                                <button class="btn btn-sm btn-icon btn-success rounded-pill btn-wave waves-effect waves-light">
                                                    <i class="ri-heart-fill"></i>
                                                </button>
                                            </div>
                                            <div>
                                                <span class="badge nft-like-badge text-fixed-white"><i class="ri-heart-fill me-1 text-danger align-middle d-inline-block"></i>0.47k</span>
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <div class="d-flex align-items-center mb-3">
                                                <div class="me-2 lh-1">
                                                    <span class="avatar avatar-rounded avatar-md">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/1.jpg" alt="">
                                                    </span>
                                                </div>
                                                <div>
                                                    <p class="mb-0 fw-semibold">NFTNinja</p>
                                                    <p class="fs-12 text-muted mb-0">@nftninja</p>
                                                </div>
                                            </div>
                                            <p class="mb-0 text-fixed-white nft-auction-time">
                                                04hrs : 24m : 38s
                                            </p>
                                            <p class="fs-15 fw-semibold mb-2"><a href="javscript:void(0);">Digital Dreamscape</a></p>
                                            <div class="d-flex flex-wrap align-itesm-center justify-content-between">
                                                <div class="fw-semibold">
                                                    Highest Bid -
                                                </div>
                                                <div class="d-flex flex-wrap align-items-center lh-1">
                                                    <span class="avatar avatar-xs me-1">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/square-color/Ethereum.svg" alt="">
                                                    </span>0.24ETH
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--End::row -->

                </div>

<?php $content = ob_get_clean(); ?>
<!-- This code is useful for content -->

<!-- This code is useful for internal scripts  -->
<?php ob_start(); ?>

        <!-- FILEPOND JS -->
        <script src="<?php echo $baseUrl; ?>/assets/libs/filepond/filepond.min.js"></script>
        <script src="<?php echo $baseUrl; ?>/assets/libs/filepond-plugin-image-preview/filepond-plugin-image-preview.min.js"></script>
        <script src="<?php echo $baseUrl; ?>/assets/libs/filepond-plugin-image-exif-orientation/filepond-plugin-image-exif-orientation.min.js"></script>
        <script src="<?php echo $baseUrl; ?>/assets/libs/filepond-plugin-file-validate-size/filepond-plugin-file-validate-size.min.js"></script>
        <script src="<?php echo $baseUrl; ?>/assets/libs/filepond-plugin-file-encode/filepond-plugin-file-encode.min.js"></script>
        <script src="<?php echo $baseUrl; ?>/assets/libs/filepond-plugin-image-edit/filepond-plugin-image-edit.min.js"></script>
        <script src="<?php echo $baseUrl; ?>/assets/libs/filepond-plugin-file-validate-type/filepond-plugin-file-validate-type.min.js"></script>
        <script src="<?php echo $baseUrl; ?>/assets/libs/filepond-plugin-file-validate-type/filepond-plugin-file-validate-type.min.js"></script>
        <script src="<?php echo $baseUrl; ?>/assets/libs/filepond-plugin-image-crop/filepond-plugin-image-crop.min.js"></script>
        <script src="<?php echo $baseUrl; ?>/assets/libs/filepond-plugin-image-resize/filepond-plugin-image-resize.min.js"></script>
        <script src="<?php echo $baseUrl; ?>/assets/libs/filepond-plugin-image-transform/filepond-plugin-image-transform.min.js"></script>

        <!-- CREATE NFT JS -->
        <script src="<?php echo $baseUrl; ?>/assets/js/nft-create.js"></script>
        
<?php $scripts = ob_get_clean(); ?>
<!-- This code is useful for internal scripts  -->

<!-- This code use for render base file -->
<?php include 'layouts/base.php'; ?>
<!-- This code use for render base file -->