<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->
<?php
    $rootFolder = basename($_SERVER['DOCUMENT_ROOT']);
    $baseUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . str_replace('/pages', '', dirname($_SERVER['SCRIPT_NAME']));
?>
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->

<!-- This code is useful for internal styles  -->
<?php ob_start(); ?>

        <!-- FULL CALENDAR CSS -->
        <link rel="stylesheet" href="<?php echo $baseUrl; ?>/assets/libs/fullcalendar/main.min.css">

<?php $styles = ob_get_clean(); ?>
<!-- This code is useful for internal styles  -->

<!-- This code is useful for content -->
<?php ob_start(); ?>

              <div class="container-fluid">

                <!-- Page Header -->
                <div class="d-md-flex d-block align-items-center justify-content-between my-4 page-header-breadcrumb">
                    <h1 class="page-title fw-semibold fs-18 mb-0">Full Calendar</h1>
                    <div class="ms-md-1 ms-0">
                        <nav>
                            <ol class="breadcrumb mb-0">
                                <li class="breadcrumb-item"><a href="javascript:void(0);">Apps</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Full Calendar</li>
                            </ol>
                        </nav>
                    </div>
                </div>
                <!-- Page Header Close -->

                <!-- Start::row-1 -->
                <div class="row">
                    <div class="col-xl-3">
                        <div class="card custom-card">
                            <div class="card-header d-grid">
                                <button class="btn btn-primary-light btn-wave"><i class="ri-add-line align-middle me-1 fw-semibold d-inline-block"></i>Create New Event</button>
                            </div>
                            <div class="card-body p-0">
                                <div id="external-events" class="border-bottom p-3">
                                    <div
                                      class="fc-event fc-h-event fc-daygrid-event fc-daygrid-block-event bg-primary border border-primary">
                                      <div class="fc-event-main">Calendar Events</div>
                                    </div>
                                    <div
                                      class="fc-event fc-h-event fc-daygrid-event fc-daygrid-block-event bg-secondary border border-secondary"
                                      data-class="bg-secondary">
                                      <div class="fc-event-main">Birthday EVents</div>
                                    </div>
                                    <div class="fc-event fc-h-event fc-daygrid-event fc-daygrid-block-event bg-success border border-success"
                                      data-class="bg-success">
                                      <div class="fc-event-main">Holiday Calendar</div>
                                    </div>
                                    <div class="fc-event fc-h-event fc-daygrid-event fc-daygrid-block-event bg-info border border-info"
                                      data-class="bg-info">
                                      <div class="fc-event-main">Office Events</div>
                                    </div>
                                    <div
                                      class="fc-event fc-h-event fc-daygrid-event fc-daygrid-block-event bg-warning border border-warning"
                                      data-class="bg-warning">
                                      <div class="fc-event-main">Other Events</div>
                                    </div>
                                    <div class="fc-event fc-h-event fc-daygrid-event fc-daygrid-block-event bg-danger border border-danger"
                                      data-class="bg-danger">
                                      <div class="fc-event-main">Festival Events</div>
                                    </div>
                                    <div class="fc-event fc-h-event fc-daygrid-event fc-daygrid-block-event bg-teal border border-teal"
                                      data-class="bg-danger">
                                      <div class="fc-event-main">Timeline Events</div>
                                    </div>
                                </div>
                                <div class="p-3">
                                  <div class="d-flex align-items-center justify-content-between">
                                    <h6 class="fw-semibold">
                                      Activity :
                                    </h6>
                                    <button class="btn btn-primary-light btn-sm btn-wave">View All</button>
                                  </div>
                                </div>
                                <div class="p-3 border-bottom" id="full-calendar-activity">
                                  <ul class="list-unstyled mb-0 fullcalendar-events-activity">
                                    <li>
                                      <div class="d-flex align-items-center justify-content-between flex-wrap">
                                        <p class="mb-1 fw-semibold">
                                          Monday, Jan 1,2023
                                        </p>
                                        <span class="badge bg-light text-default mb-1">12:00PM - 1:00PM</span>
                                      </div>
                                      <p class="mb-0 text-muted fs-12">
                                        Meeting with a client about new project requirement.
                                      </p>
                                    </li>
                                    <li>
                                      <div class="d-flex align-items-center justify-content-between flex-wrap">
                                        <p class="mb-1 fw-semibold">
                                          Thursday, Dec 29,2022
                                        </p>
                                        <span class="badge bg-success mb-1">Completed</span>
                                      </div>
                                      <p class="mb-0 text-muted fs-12">
                                        Birthday party of niha suka
                                      </p>
                                    </li>
                                    <li>
                                      <div class="d-flex align-items-center justify-content-between flex-wrap">
                                        <p class="mb-1 fw-semibold">
                                          Wednesday, Jan 3,2023
                                        </p>
                                        <span class="badge bg-warning-transparent mb-1">Reminder</span>
                                      </div>
                                      <p class="mb-0 text-muted fs-12">
                                        WOrk taget for new project is completing
                                      </p>
                                    </li>
                                    <li>
                                      <div class="d-flex align-items-center justify-content-between flex-wrap">
                                        <p class="mb-1 fw-semibold">
                                          Friday, Jan 20,2023
                                        </p>
                                        <span class="badge bg-light text-default mb-1">06:00PM - 09:00PM</span>
                                      </div>
                                      <p class="mb-0 text-muted fs-12">
                                        Watch new movie with family
                                      </p>
                                    </li>
                                    <li>
                                      <div class="d-flex align-items-center justify-content-between flex-wrap">
                                        <p class="mb-1 fw-semibold">
                                          Saturday, Jan 07,2023
                                        </p>
                                        <span class="badge bg-danger-transparent mb-1">Due Date</span>
                                      </div>
                                      <p class="mb-0 text-muted fs-12">
                                        Last day to pay the electricity bill and water bill.need to check the bank details.
                                      </p>
                                    </li>
                                  </ul>
                                </div>
                                <div class="p-3">
                                  <img src="<?php echo $baseUrl; ?>/assets/images/media/media-83.svg" alt="">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-9">
                        <div class="card custom-card">
                            <div class="card-header">
                                <div class="card-title">Full Calendar</div>
                            </div>
                            <div class="card-body">
                                <div id='calendar2'></div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--End::row-1 -->

              </div>

<?php $content = ob_get_clean(); ?>
<!-- This code is useful for content -->

<!-- This code is useful for internal scripts  -->
<?php ob_start(); ?>

        <!-- MOMENT JS -->
        <script src="<?php echo $baseUrl; ?>/assets/libs/moment/moment.js"></script>

        <!-- FULLCALENDAR JS -->
        <script src="<?php echo $baseUrl; ?>/assets/libs/fullcalendar/main.min.js"></script>
        <script src="<?php echo $baseUrl; ?>/assets/js/fullcalendar.js"></script>

<?php $scripts = ob_get_clean(); ?>
<!-- This code is useful for internal scripts  -->

<!-- This code use for render base file -->
<?php include 'layouts/base.php'; ?>
<!-- This code use for render base file -->