<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->
<?php
    $rootFolder = basename($_SERVER['DOCUMENT_ROOT']);
    $baseUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . str_replace('/pages', '', dirname($_SERVER['SCRIPT_NAME']));
?>
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->

<!-- This code is useful for internal styles  -->
<?php ob_start(); ?>


<?php $styles = ob_get_clean(); ?>
<!-- This code is useful for internal styles  -->

<!-- This code is useful for content -->
<?php ob_start(); ?>

                <div class="container-fluid">

                    <!-- Page Header -->
                    <div class="d-md-flex d-block align-items-center justify-content-between my-4 page-header-breadcrumb">
                        <h1 class="page-title fw-semibold fs-18 mb-0">Market Place</h1>
                        <div class="ms-md-1 ms-0">
                            <nav>
                                <ol class="breadcrumb mb-0">
                                    <li class="breadcrumb-item"><a href="javascript:void(0);">NFT</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">Market Place</li>
                                </ol>
                            </nav>
                        </div>
                    </div>
                    <!-- Page Header Close -->

                    <!-- Start::row-1 -->
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="card custom-card">
                                <div class="card-body">
                                    <div class="d-flex align-items-center justify-content-between flex-wrap gap-2">
                                        <div>
                                            <ul class="nav nav-tabs nav-tabs-header mb-0" role="tablist">
                                                <li class="nav-item" role="presentation">
                                                    <a class="nav-link active" data-bs-toggle="tab" role="tab" aria-current="page" href="#nft-all" aria-selected="true">All</a>
                                                </li>
                                                <li class="nav-item" role="presentation">
                                                    <a class="nav-link" data-bs-toggle="tab" role="tab" aria-current="page" href="#nft-art" aria-selected="false" tabindex="-1">Art</a>
                                                </li>
                                                <li class="nav-item" role="presentation">
                                                    <a class="nav-link" data-bs-toggle="tab" role="tab" aria-current="page" href="#nft-gaming" aria-selected="false" tabindex="-1">Gaming</a>
                                                </li>
                                                <li class="nav-item" role="presentation">
                                                    <a class="nav-link" data-bs-toggle="tab" role="tab" aria-current="page" href="#nft-domain" aria-selected="false" tabindex="-1">Domain</a>
                                                </li>
                                                <li class="nav-item" role="presentation">
                                                    <a class="nav-link" data-bs-toggle="tab" role="tab" aria-current="page" href="#nft-music" aria-selected="false" tabindex="-1">Music</a>
                                                </li>
                                                <li class="nav-item" role="presentation">
                                                    <a class="nav-link" data-bs-toggle="tab" role="tab" aria-current="page" href="#nft-realestate" aria-selected="false" tabindex="-1">Real Estate</a>
                                                </li>
                                                <li class="nav-item" role="presentation">
                                                    <a class="nav-link" data-bs-toggle="tab" role="tab" aria-current="page" href="#nft-sports" aria-selected="false" tabindex="-1">Sports</a>
                                                </li>
                                                <li class="nav-item" role="presentation">
                                                    <a class="nav-link" data-bs-toggle="tab" role="tab" aria-current="page" href="#nft-fashion" aria-selected="false" tabindex="-1">Fashion</a>
                                                </li>
                                                <li class="nav-item" role="presentation">
                                                    <a class="nav-link" data-bs-toggle="tab" role="tab" aria-current="page" href="#nft-avatars" aria-selected="false" tabindex="-1">Avatars</a>
                                                </li>
                                                <li class="nav-item" role="presentation">
                                                    <a class="nav-link" data-bs-toggle="tab" role="tab" aria-current="page" href="#nft-memes" aria-selected="false" tabindex="-1">Memes</a>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="btn-list">
                                            <button type="button" class="btn btn-sm btn-secondary btn-wave">Filters</button>
                                            <a href="javascript:void(0);" class="btn btn-sm btn-wave btn-primary waves-effect waves-light" data-bs-toggle="dropdown" aria-expanded="false">
                                                Sort By<i class="ri-arrow-down-s-line align-middle ms-1 d-inline-block"></i>
                                            </a>
                                            <ul class="dropdown-menu" role="menu">
                                                <li><a class="dropdown-item" href="javascript:void(0);">New Collection</a></li>
                                                <li><a class="dropdown-item" href="javascript:void(0);">High - Low</a></li>
                                                <li><a class="dropdown-item" href="javascript:void(0);">Low - High</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--End::row-1 -->

                    <!-- Start:: row-2 -->
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="tab-content">
                                <div class="tab-pane show active p-0 border-0" id="nft-all" role="tabpanel">
                                    <div class="row">
                                        <div class="col-xxl-2 col-xl-3 col-lg-4 col-md-4 col-sm-6 col-12">
                                            <div class="card custom-card">
                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/18.png" class="card-img-top" alt="...">
                                                <div class="d-flex align-items-center justify-content-between nft-like-section w-100 px-3">
                                                    <div class="flex-fill">
                                                        <button type="button" aria-label="button" class="btn btn-sm btn-icon btn-success rounded-pill btn-wave waves-effect waves-light">
                                                            <i class="ri-heart-fill"></i>
                                                        </button>
                                                    </div>
                                                    <div>
                                                        <span class="badge nft-like-badge text-fixed-white"><i class="ri-heart-fill me-1 text-danger align-middle d-inline-block"></i>0.47k</span>
                                                    </div>
                                                </div>
                                                <div class="card-body">
                                                    <div class="d-flex align-items-center mb-3">
                                                        <div class="me-2 lh-1">
                                                            <span class="avatar avatar-rounded avatar-md">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/1.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <p class="mb-0 fw-semibold">NFTNinja</p>
                                                            <p class="fs-12 text-muted mb-0">@nftninja</p>
                                                        </div>
                                                    </div>
                                                    <p class="mb-0 text-fixed-white nft-auction-time">
                                                        04hrs : 24m : 38s
                                                    </p>
                                                    <p class="fs-15 fw-semibold mb-2"><a href="javascript:void(0);">Digital Dreamscape</a></p>
                                                    <div class="d-flex flex-wrap align-itesm-center justify-content-between mb-4">
                                                        <div class="fw-semibold">
                                                            Highest Bid -
                                                        </div>
                                                        <div class="d-flex flex-wrap align-items-center lh-1">
                                                            <span class="avatar avatar-xs me-1">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/square-color/Ethereum.svg" alt="">
                                                            </span>0.24ETH
                                                        </div>
                                                    </div>
                                                    <div class="d-grid">
                                                        <button type="button" class="btn btn-primary-light btn-wave waves-effect waves-light">Place Bid</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xxl-2 col-xl-3 col-lg-4 col-md-4 col-sm-6 col-12">
                                            <div class="card custom-card">
                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/19.png" class="card-img-top" alt="...">
                                                <div class="d-flex align-items-center justify-content-between nft-like-section w-100 px-3">
                                                    <div class="flex-fill">
                                                        <button aria-label="button" type="button" class="btn btn-sm btn-icon btn-success rounded-pill btn-wave waves-effect waves-light">
                                                            <i class="ri-heart-fill"></i>
                                                        </button>
                                                    </div>
                                                    <div>
                                                        <span class="badge nft-like-badge text-fixed-white"><i class="ri-heart-fill me-1 text-danger align-middle d-inline-block"></i>1.19k</span>
                                                    </div>
                                                </div>
                                                <div class="card-body">
                                                    <div class="d-flex align-items-center mb-3">
                                                        <div class="me-2 lh-1">
                                                            <span class="avatar avatar-rounded avatar-md">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/2.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <p class="mb-0 fw-semibold">ArtTechie</p>
                                                            <p class="fs-12 text-muted mb-0">@arttechie</p>
                                                        </div>
                                                    </div>
                                                    <p class="mb-0 text-fixed-white nft-auction-time">
                                                        04hrs : 24m : 38s
                                                    </p>
                                                    <p class="fs-15 fw-semibold mb-2"><a href="javascript:void(0);">Neo-Nebulae</a></p>
                                                    <div class="d-flex flex-wrap align-itesm-center justify-content-between mb-4">
                                                        <div class="fw-semibold">
                                                            Highest Bid -
                                                        </div>
                                                        <div class="d-flex flex-wrap align-items-center lh-1">
                                                            <span class="avatar avatar-xs me-1">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/square-color/Ethereum.svg" alt="">
                                                            </span>0.32ETH
                                                        </div>
                                                    </div>
                                                    <div class="d-grid">
                                                        <button type="button" class="btn btn-primary-light btn-wave waves-effect waves-light">Place Bid</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xxl-2 col-xl-3 col-lg-4 col-md-4 col-sm-6 col-12">
                                            <div class="card custom-card">
                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/20.png" class="card-img-top" alt="...">
                                                <div class="d-flex align-items-center justify-content-between nft-like-section w-100 px-3">
                                                    <div class="flex-fill">
                                                        <button aria-label="button" type="button" class="btn btn-sm btn-icon btn-success rounded-pill btn-wave waves-effect waves-light">
                                                            <i class="ri-heart-fill"></i>
                                                        </button>
                                                    </div>
                                                    <div>
                                                        <span class="badge nft-like-badge text-fixed-white"><i class="ri-heart-fill me-1 text-danger align-middle d-inline-block"></i>2.05k</span>
                                                    </div>
                                                </div>
                                                <div class="card-body">
                                                    <div class="d-flex align-items-center mb-3">
                                                        <div class="me-2 lh-1">
                                                            <span class="avatar avatar-rounded avatar-md">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/3.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <p class="mb-0 fw-semibold">BitMaster</p>
                                                            <p class="fs-12 text-muted mb-0">@bit_master</p>
                                                        </div>
                                                    </div>
                                                    <p class="mb-0 text-fixed-white nft-auction-time">
                                                        04hrs : 24m : 38s
                                                    </p>
                                                    <p class="fs-15 fw-semibold mb-2"><a href="javascript:void(0);">Chromatic Chaos</a></p>
                                                    <div class="d-flex flex-wrap align-itesm-center justify-content-between mb-4">
                                                        <div class="fw-semibold">
                                                            Highest Bid -
                                                        </div>
                                                        <div class="d-flex flex-wrap align-items-center lh-1">
                                                            <span class="avatar avatar-xs me-1">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/square-color/Ethereum.svg" alt="">
                                                            </span>0.19ETH
                                                        </div>
                                                    </div>
                                                    <div class="d-grid">
                                                        <button type="button" class="btn btn-primary-light btn-wave waves-effect waves-light">Place Bid</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xxl-2 col-xl-3 col-lg-4 col-md-4 col-sm-6 col-12">
                                            <div class="card custom-card">
                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/21.png" class="card-img-top" alt="...">
                                                <div class="d-flex align-items-center justify-content-between nft-like-section w-100 px-3">
                                                    <div class="flex-fill">
                                                        <button type="button" aria-label="button" class="btn btn-sm btn-icon btn-success rounded-pill btn-wave waves-effect waves-light">
                                                            <i class="ri-heart-fill"></i>
                                                        </button>
                                                    </div>
                                                    <div>
                                                        <span class="badge nft-like-badge text-fixed-white"><i class="ri-heart-fill me-1 text-danger align-middle d-inline-block"></i>0.19k</span>
                                                    </div>
                                                </div>
                                                <div class="card-body">
                                                    <div class="d-flex align-items-center mb-3">
                                                        <div class="me-2 lh-1">
                                                            <span class="avatar avatar-rounded avatar-md">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/4.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <p class="mb-0 fw-semibold">CyberCanvas</p>
                                                            <p class="fs-12 text-muted mb-0">@cybercanvas</p>
                                                        </div>
                                                    </div>
                                                    <p class="mb-0 text-fixed-white nft-auction-time">
                                                        04hrs : 24m : 38s
                                                    </p>
                                                    <p class="fs-15 fw-semibold mb-2"><a href="javascript:void(0);">Surreal Synthesis</a></p>
                                                    <div class="d-flex flex-wrap align-itesm-center justify-content-between mb-4">
                                                        <div class="fw-semibold">
                                                            Highest Bid -
                                                        </div>
                                                        <div class="d-flex flex-wrap align-items-center lh-1">
                                                            <span class="avatar avatar-xs me-1">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/square-color/Ethereum.svg" alt="">
                                                            </span>0.11ETH
                                                        </div>
                                                    </div>
                                                    <div class="d-grid">
                                                        <button type="button" class="btn btn-primary-light btn-wave waves-effect waves-light">Place Bid</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xxl-2 col-xl-3 col-lg-4 col-md-4 col-sm-6 col-12">
                                            <div class="card custom-card">
                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/22.png" class="card-img-top" alt="...">
                                                <div class="d-flex align-items-center justify-content-between nft-like-section w-100 px-3">
                                                    <div class="flex-fill">
                                                        <button type="button" aria-label="button" class="btn btn-sm btn-icon btn-success rounded-pill btn-wave waves-effect waves-light">
                                                            <i class="ri-heart-fill"></i>
                                                        </button>
                                                    </div>
                                                    <div>
                                                        <span class="badge nft-like-badge text-fixed-white"><i class="ri-heart-fill me-1 text-danger align-middle d-inline-block"></i>0.65k</span>
                                                    </div>
                                                </div>
                                                <div class="card-body">
                                                    <div class="d-flex align-items-center mb-3">
                                                        <div class="me-2 lh-1">
                                                            <span class="avatar avatar-rounded avatar-md">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/5.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <p class="mb-0 fw-semibold">DigitalDreamer</p>
                                                            <p class="fs-12 text-muted mb-0">@d_dreamer</p>
                                                        </div>
                                                    </div>
                                                    <p class="mb-0 text-fixed-white nft-auction-time">
                                                        04hrs : 24m : 38s
                                                    </p>
                                                    <p class="fs-15 fw-semibold mb-2"><a href="javascript:void(0);">Virtual Visions</a></p>
                                                    <div class="d-flex flex-wrap align-itesm-center justify-content-between mb-4">
                                                        <div class="fw-semibold">
                                                            Highest Bid -
                                                        </div>
                                                        <div class="d-flex flex-wrap align-items-center lh-1">
                                                            <span class="avatar avatar-xs me-1">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/square-color/Ethereum.svg" alt="">
                                                            </span>0.10ETH
                                                        </div>
                                                    </div>
                                                    <div class="d-grid">
                                                        <button type="button" class="btn btn-primary-light btn-wave waves-effect waves-light">Place Bid</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xxl-2 col-xl-3 col-lg-4 col-md-4 col-sm-6 col-12">
                                            <div class="card custom-card">
                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/23.png" class="card-img-top" alt="...">
                                                <div class="d-flex align-items-center justify-content-between nft-like-section w-100 px-3">
                                                    <div class="flex-fill">
                                                        <button type="button" aria-label="button" class="btn btn-sm btn-icon btn-success rounded-pill btn-wave waves-effect waves-light">
                                                            <i class="ri-heart-fill"></i>
                                                        </button>
                                                    </div>
                                                    <div>
                                                        <span class="badge nft-like-badge text-fixed-white"><i class="ri-heart-fill me-1 text-danger align-middle d-inline-block"></i>0.52k</span>
                                                    </div>
                                                </div>
                                                <div class="card-body">
                                                    <div class="d-flex align-items-center mb-3">
                                                        <div class="me-2 lh-1">
                                                            <span class="avatar avatar-rounded avatar-md">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/6.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <p class="mb-0 fw-semibold">PixelProphet</p>
                                                            <p class="fs-12 text-muted mb-0">@pixelprophet</p>
                                                        </div>
                                                    </div>
                                                    <p class="mb-0 text-fixed-white nft-auction-time">
                                                        04hrs : 24m : 38s
                                                    </p>
                                                    <p class="fs-15 fw-semibold mb-2"><a href="javascript:void(0);">Electric Euphoria</a></p>
                                                    <div class="d-flex flex-wrap align-itesm-center justify-content-between mb-4">
                                                        <div class="fw-semibold">
                                                            Highest Bid -
                                                        </div>
                                                        <div class="d-flex flex-wrap align-items-center lh-1">
                                                            <span class="avatar avatar-xs me-1">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/square-color/Ethereum.svg" alt="">
                                                            </span>0.45ETH
                                                        </div>
                                                    </div>
                                                    <div class="d-grid">
                                                        <button type="button" class="btn btn-primary-light btn-wave waves-effect waves-light">Place Bid</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xxl-2 col-xl-3 col-lg-4 col-md-4 col-sm-6 col-12">
                                            <div class="card custom-card">
                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/24.png" class="card-img-top" alt="...">
                                                <div class="d-flex align-items-center justify-content-between nft-like-section w-100 px-3">
                                                    <div class="flex-fill">
                                                        <button type="button" aria-label="button" class="btn btn-sm btn-icon btn-success rounded-pill btn-wave waves-effect waves-light">
                                                            <i class="ri-heart-fill"></i>
                                                        </button>
                                                    </div>
                                                    <div>
                                                        <span class="badge nft-like-badge text-fixed-white"><i class="ri-heart-fill me-1 text-danger align-middle d-inline-block"></i>1.55k</span>
                                                    </div>
                                                </div>
                                                <div class="card-body">
                                                    <div class="d-flex align-items-center mb-3">
                                                        <div class="me-2 lh-1">
                                                            <span class="avatar avatar-rounded avatar-md">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/7.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <p class="mb-0 fw-semibold">TechnoTalent</p>
                                                            <p class="fs-12 text-muted mb-0">@techno_t</p>
                                                        </div>
                                                    </div>
                                                    <p class="mb-0 text-fixed-white nft-auction-time">
                                                        04hrs : 24m : 38s
                                                    </p>
                                                    <p class="fs-15 fw-semibold mb-2"><a href="javascript:void(0);">Crypto Cosmos</a></p>
                                                    <div class="d-flex flex-wrap align-itesm-center justify-content-between mb-4">
                                                        <div class="fw-semibold">
                                                            Highest Bid -
                                                        </div>
                                                        <div class="d-flex flex-wrap align-items-center lh-1">
                                                            <span class="avatar avatar-xs me-1">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/square-color/Ethereum.svg" alt="">
                                                            </span>0.38ETH
                                                        </div>
                                                    </div>
                                                    <div class="d-grid">
                                                        <button type="button" class="btn btn-primary-light btn-wave waves-effect waves-light">Place Bid</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xxl-2 col-xl-3 col-lg-4 col-md-4 col-sm-6 col-12">
                                            <div class="card custom-card">
                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/25.png" class="card-img-top" alt="...">
                                                <div class="d-flex align-items-center justify-content-between nft-like-section w-100 px-3">
                                                    <div class="flex-fill">
                                                        <button type="button" aria-label="button" class="btn btn-sm btn-icon btn-success rounded-pill btn-wave waves-effect waves-light">
                                                            <i class="ri-heart-fill"></i>
                                                        </button>
                                                    </div>
                                                    <div>
                                                        <span class="badge nft-like-badge text-fixed-white"><i class="ri-heart-fill me-1 text-danger align-middle d-inline-block"></i>1.75k</span>
                                                    </div>
                                                </div>
                                                <div class="card-body">
                                                    <div class="d-flex align-items-center mb-3">
                                                        <div class="me-2 lh-1">
                                                            <span class="avatar avatar-rounded avatar-md">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/8.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <p class="mb-0 fw-semibold">PixelMaestro</p>
                                                            <p class="fs-12 text-muted mb-0">@pixelmaestro</p>
                                                        </div>
                                                    </div>
                                                    <p class="mb-0 text-fixed-white nft-auction-time">
                                                        04hrs : 24m : 38s
                                                    </p>
                                                    <p class="fs-15 fw-semibold mb-2"><a href="javascript:void(0);">Pixel Prism</a></p>
                                                    <div class="d-flex flex-wrap align-itesm-center justify-content-between mb-4">
                                                        <div class="fw-semibold">
                                                            Highest Bid -
                                                        </div>
                                                        <div class="d-flex flex-wrap align-items-center lh-1">
                                                            <span class="avatar avatar-xs me-1">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/square-color/Ethereum.svg" alt="">
                                                            </span>0.23ETH
                                                        </div>
                                                    </div>
                                                    <div class="d-grid">
                                                        <button type="button" class="btn btn-primary-light btn-wave waves-effect waves-light">Place Bid</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xxl-2 col-xl-3 col-lg-4 col-md-4 col-sm-6 col-12">
                                            <div class="card custom-card">
                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/26.png" class="card-img-top" alt="...">
                                                <div class="d-flex align-items-center justify-content-between nft-like-section w-100 px-3">
                                                    <div class="flex-fill">
                                                        <button type="button" aria-label="button" class="btn btn-sm btn-icon btn-success rounded-pill btn-wave waves-effect waves-light">
                                                            <i class="ri-heart-fill"></i>
                                                        </button>
                                                    </div>
                                                    <div>
                                                        <span class="badge nft-like-badge text-fixed-white"><i class="ri-heart-fill me-1 text-danger align-middle d-inline-block"></i>0.83k</span>
                                                    </div>
                                                </div>
                                                <div class="card-body">
                                                    <div class="d-flex align-items-center mb-3">
                                                        <div class="me-2 lh-1">
                                                            <span class="avatar avatar-rounded avatar-md">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/9.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <p class="mb-0 fw-semibold">BitBard</p>
                                                            <p class="fs-12 text-muted mb-0">@bitbard</p>
                                                        </div>
                                                    </div>
                                                    <p class="mb-0 text-fixed-white nft-auction-time">
                                                        04hrs : 24m : 38s
                                                    </p>
                                                    <p class="fs-15 fw-semibold mb-2"><a href="javascript:void(0);">Meta-Morphosis</a></p>
                                                    <div class="d-flex flex-wrap align-itesm-center justify-content-between mb-4">
                                                        <div class="fw-semibold">
                                                            Highest Bid -
                                                        </div>
                                                        <div class="d-flex flex-wrap align-items-center lh-1">
                                                            <span class="avatar avatar-xs me-1">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/square-color/Ethereum.svg" alt="">
                                                            </span>0.38ETH
                                                        </div>
                                                    </div>
                                                    <div class="d-grid">
                                                        <button type="button" class="btn btn-primary-light btn-wave waves-effect waves-light">Place Bid</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xxl-2 col-xl-3 col-lg-4 col-md-4 col-sm-6 col-12">
                                            <div class="card custom-card">
                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/27.png" class="card-img-top" alt="...">
                                                <div class="d-flex align-items-center justify-content-between nft-like-section w-100 px-3">
                                                    <div class="flex-fill">
                                                        <button type="button" aria-label="button" class="btn btn-sm btn-icon btn-success rounded-pill btn-wave waves-effect waves-light">
                                                            <i class="ri-heart-fill"></i>
                                                        </button>
                                                    </div>
                                                    <div>
                                                        <span class="badge nft-like-badge text-fixed-white"><i class="ri-heart-fill me-1 text-danger align-middle d-inline-block"></i>0.16k</span>
                                                    </div>
                                                </div>
                                                <div class="card-body">
                                                    <div class="d-flex align-items-center mb-3">
                                                        <div class="me-2 lh-1">
                                                            <span class="avatar avatar-rounded avatar-md">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/10.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <p class="mb-0 fw-semibold">CryptoCraft</p>
                                                            <p class="fs-12 text-muted mb-0">@cryptocraft</p>
                                                        </div>
                                                    </div>
                                                    <p class="mb-0 text-fixed-white nft-auction-time">
                                                        04hrs : 24m : 38s
                                                    </p>
                                                    <p class="fs-15 fw-semibold mb-2"><a href="javascript:void(0);">Virtual Veracity</a></p>
                                                    <div class="d-flex flex-wrap align-itesm-center justify-content-between mb-4">
                                                        <div class="fw-semibold">
                                                            Highest Bid -
                                                        </div>
                                                        <div class="d-flex flex-wrap align-items-center lh-1">
                                                            <span class="avatar avatar-xs me-1">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/square-color/Ethereum.svg" alt="">
                                                            </span>0.15ETH
                                                        </div>
                                                    </div>
                                                    <div class="d-grid">
                                                        <button type="button" class="btn btn-primary-light btn-wave waves-effect waves-light">Place Bid</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xxl-2 col-xl-3 col-lg-4 col-md-4 col-sm-6 col-12">
                                            <div class="card custom-card">
                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/28.png" class="card-img-top" alt="...">
                                                <div class="d-flex align-items-center justify-content-between nft-like-section w-100 px-3">
                                                    <div class="flex-fill">
                                                        <button type="button" aria-label="button" class="btn btn-sm btn-icon btn-success rounded-pill btn-wave waves-effect waves-light">
                                                            <i class="ri-heart-fill"></i>
                                                        </button>
                                                    </div>
                                                    <div>
                                                        <span class="badge nft-like-badge text-fixed-white"><i class="ri-heart-fill me-1 text-danger align-middle d-inline-block"></i>1.38k</span>
                                                    </div>
                                                </div>
                                                <div class="card-body">
                                                    <div class="d-flex align-items-center mb-3">
                                                        <div class="me-2 lh-1">
                                                            <span class="avatar avatar-rounded avatar-md">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/11.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <p class="mb-0 fw-semibold">ArtWizard</p>
                                                            <p class="fs-12 text-muted mb-0">@artwizard</p>
                                                        </div>
                                                    </div>
                                                    <p class="mb-0 text-fixed-white nft-auction-time">
                                                        04hrs : 24m : 38s
                                                    </p>
                                                    <p class="fs-15 fw-semibold mb-2"><a href="javascript:void(0);">Quantum Quirk</a></p>
                                                    <div class="d-flex flex-wrap align-itesm-center justify-content-between mb-4">
                                                        <div class="fw-semibold">
                                                            Highest Bid -
                                                        </div>
                                                        <div class="d-flex flex-wrap align-items-center lh-1">
                                                            <span class="avatar avatar-xs me-1">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/square-color/Ethereum.svg" alt="">
                                                            </span>0.33ETH
                                                        </div>
                                                    </div>
                                                    <div class="d-grid">
                                                        <button type="button" class="btn btn-primary-light btn-wave waves-effect waves-light">Place Bid</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xxl-2 col-xl-3 col-lg-4 col-md-4 col-sm-6 col-12">
                                            <div class="card custom-card">
                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/29.png" class="card-img-top" alt="...">
                                                <div class="d-flex align-items-center justify-content-between nft-like-section w-100 px-3">
                                                    <div class="flex-fill">
                                                        <button type="button" aria-label="button" class="btn btn-sm btn-icon btn-success rounded-pill btn-wave waves-effect waves-light">
                                                            <i class="ri-heart-fill"></i>
                                                        </button>
                                                    </div>
                                                    <div>
                                                        <span class="badge nft-like-badge text-fixed-white"><i class="ri-heart-fill me-1 text-danger align-middle d-inline-block"></i>1.32k</span>
                                                    </div>
                                                </div>
                                                <div class="card-body">
                                                    <div class="d-flex align-items-center mb-3">
                                                        <div class="me-2 lh-1">
                                                            <span class="avatar avatar-rounded avatar-md">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/12.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <p class="mb-0 fw-semibold">DigitalMuse</p>
                                                            <p class="fs-12 text-muted mb-0">@digitalmuse</p>
                                                        </div>
                                                    </div>
                                                    <p class="mb-0 text-fixed-white nft-auction-time">
                                                        04hrs : 24m : 38s
                                                    </p>
                                                    <p class="fs-15 fw-semibold mb-2"><a href="javascript:void(0);">Cybernetic Collage</a></p>
                                                    <div class="d-flex flex-wrap align-itesm-center justify-content-between mb-4">
                                                        <div class="fw-semibold">
                                                            Highest Bid -
                                                        </div>
                                                        <div class="d-flex flex-wrap align-items-center lh-1">
                                                            <span class="avatar avatar-xs me-1">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/square-color/Ethereum.svg" alt="">
                                                            </span>0.59ETH
                                                        </div>
                                                    </div>
                                                    <div class="d-grid">
                                                        <button type="button" class="btn btn-primary-light btn-wave waves-effect waves-light">Place Bid</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <nav aria-label="Page navigation">
                                            <ul class="pagination justify-content-end mb-4">
                                                <li class="page-item disabled">
                                                    <a class="page-link">Previous</a>
                                                </li>
                                                <li class="page-item"><a class="page-link" href="javascript:void(0);">1</a></li>
                                                <li class="page-item"><a class="page-link" href="javascript:void(0);">2</a></li>
                                                <li class="page-item"><a class="page-link" href="javascript:void(0);">3</a></li>
                                                <li class="page-item">
                                                    <a class="page-link" href="javascript:void(0);">Next</a>
                                                </li>
                                            </ul>
                                        </nav>
                                    </div>
                                </div>
                                <div class="tab-pane p-0" id="nft-art" role="tabpanel">
                                    <div class="row">
                                        <div class="col-xxl-2 col-xl-3 col-lg-4 col-md-4 col-sm-6 col-12">
                                            <div class="card custom-card">
                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/21.png" class="card-img-top" alt="...">
                                                <div class="d-flex align-items-center justify-content-between nft-like-section w-100 px-3">
                                                    <div class="flex-fill">
                                                        <button type="button" aria-label="button" class="btn btn-sm btn-icon btn-success rounded-pill btn-wave waves-effect waves-light">
                                                            <i class="ri-heart-fill"></i>
                                                        </button>
                                                    </div>
                                                    <div>
                                                        <span class="badge nft-like-badge text-fixed-white"><i class="ri-heart-fill me-1 text-danger align-middle d-inline-block"></i>0.19k</span>
                                                    </div>
                                                </div>
                                                <div class="card-body">
                                                    <div class="d-flex align-items-center mb-3">
                                                        <div class="me-2 lh-1">
                                                            <span class="avatar avatar-rounded avatar-md">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/4.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <p class="mb-0 fw-semibold">CyberCanvas</p>
                                                            <p class="fs-12 text-muted mb-0">@cybercanvas</p>
                                                        </div>
                                                    </div>
                                                    <p class="mb-0 text-fixed-white nft-auction-time">
                                                        04hrs : 24m : 38s
                                                    </p>
                                                    <p class="fs-15 fw-semibold mb-2"><a href="javascript:void(0);">Surreal Synthesis</a></p>
                                                    <div class="d-flex flex-wrap align-itesm-center justify-content-between mb-4">
                                                        <div class="fw-semibold">
                                                            Highest Bid -
                                                        </div>
                                                        <div class="d-flex flex-wrap align-items-center lh-1">
                                                            <span class="avatar avatar-xs me-1">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/square-color/Ethereum.svg" alt="">
                                                            </span>0.11ETH
                                                        </div>
                                                    </div>
                                                    <div class="d-grid">
                                                        <button type="button" class="btn btn-primary-light btn-wave waves-effect waves-light">Place Bid</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xxl-2 col-xl-3 col-lg-4 col-md-4 col-sm-6 col-12">
                                            <div class="card custom-card">
                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/25.png" class="card-img-top" alt="...">
                                                <div class="d-flex align-items-center justify-content-between nft-like-section w-100 px-3">
                                                    <div class="flex-fill">
                                                        <button type="button" aria-label="button" class="btn btn-sm btn-icon btn-success rounded-pill btn-wave waves-effect waves-light">
                                                            <i class="ri-heart-fill"></i>
                                                        </button>
                                                    </div>
                                                    <div>
                                                        <span class="badge nft-like-badge text-fixed-white"><i class="ri-heart-fill me-1 text-danger align-middle d-inline-block"></i>1.75k</span>
                                                    </div>
                                                </div>
                                                <div class="card-body">
                                                    <div class="d-flex align-items-center mb-3">
                                                        <div class="me-2 lh-1">
                                                            <span class="avatar avatar-rounded avatar-md">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/8.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <p class="mb-0 fw-semibold">PixelMaestro</p>
                                                            <p class="fs-12 text-muted mb-0">@pixelmaestro</p>
                                                        </div>
                                                    </div>
                                                    <p class="mb-0 text-fixed-white nft-auction-time">
                                                        04hrs : 24m : 38s
                                                    </p>
                                                    <p class="fs-15 fw-semibold mb-2"><a href="javascript:void(0);">Pixel Prism</a></p>
                                                    <div class="d-flex flex-wrap align-itesm-center justify-content-between mb-4">
                                                        <div class="fw-semibold">
                                                            Highest Bid -
                                                        </div>
                                                        <div class="d-flex flex-wrap align-items-center lh-1">
                                                            <span class="avatar avatar-xs me-1">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/square-color/Ethereum.svg" alt="">
                                                            </span>0.23ETH
                                                        </div>
                                                    </div>
                                                    <div class="d-grid">
                                                        <button type="button" class="btn btn-primary-light btn-wave waves-effect waves-light">Place Bid</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xxl-2 col-xl-3 col-lg-4 col-md-4 col-sm-6 col-12">
                                            <div class="card custom-card">
                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/26.png" class="card-img-top" alt="...">
                                                <div class="d-flex align-items-center justify-content-between nft-like-section w-100 px-3">
                                                    <div class="flex-fill">
                                                        <button type="button" aria-label="button" class="btn btn-sm btn-icon btn-success rounded-pill btn-wave waves-effect waves-light">
                                                            <i class="ri-heart-fill"></i>
                                                        </button>
                                                    </div>
                                                    <div>
                                                        <span class="badge nft-like-badge text-fixed-white"><i class="ri-heart-fill me-1 text-danger align-middle d-inline-block"></i>0.83k</span>
                                                    </div>
                                                </div>
                                                <div class="card-body">
                                                    <div class="d-flex align-items-center mb-3">
                                                        <div class="me-2 lh-1">
                                                            <span class="avatar avatar-rounded avatar-md">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/9.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <p class="mb-0 fw-semibold">BitBard</p>
                                                            <p class="fs-12 text-muted mb-0">@bitbard</p>
                                                        </div>
                                                    </div>
                                                    <p class="mb-0 text-fixed-white nft-auction-time">
                                                        04hrs : 24m : 38s
                                                    </p>
                                                    <p class="fs-15 fw-semibold mb-2"><a href="javascript:void(0);">Meta-Morphosis</a></p>
                                                    <div class="d-flex flex-wrap align-itesm-center justify-content-between mb-4">
                                                        <div class="fw-semibold">
                                                            Highest Bid -
                                                        </div>
                                                        <div class="d-flex flex-wrap align-items-center lh-1">
                                                            <span class="avatar avatar-xs me-1">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/square-color/Ethereum.svg" alt="">
                                                            </span>0.38ETH
                                                        </div>
                                                    </div>
                                                    <div class="d-grid">
                                                        <button type="button" class="btn btn-primary-light btn-wave waves-effect waves-light">Place Bid</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane p-0" id="nft-gaming" role="tabpanel">
                                    <div class="row">
                                        <div class="col-xxl-2 col-xl-3 col-lg-4 col-md-4 col-sm-6 col-12">
                                            <div class="card custom-card">
                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/18.png" class="card-img-top" alt="...">
                                                <div class="d-flex align-items-center justify-content-between nft-like-section w-100 px-3">
                                                    <div class="flex-fill">
                                                        <button type="button" aria-label="button" class="btn btn-sm btn-icon btn-success rounded-pill btn-wave waves-effect waves-light">
                                                            <i class="ri-heart-fill"></i>
                                                        </button>
                                                    </div>
                                                    <div>
                                                        <span class="badge nft-like-badge text-fixed-white"><i class="ri-heart-fill me-1 text-danger align-middle d-inline-block"></i>0.47k</span>
                                                    </div>
                                                </div>
                                                <div class="card-body">
                                                    <div class="d-flex align-items-center mb-3">
                                                        <div class="me-2 lh-1">
                                                            <span class="avatar avatar-rounded avatar-md">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/1.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <p class="mb-0 fw-semibold">NFTNinja</p>
                                                            <p class="fs-12 text-muted mb-0">@nftninja</p>
                                                        </div>
                                                    </div>
                                                    <p class="mb-0 text-fixed-white nft-auction-time">
                                                        04hrs : 24m : 38s
                                                    </p>
                                                    <p class="fs-15 fw-semibold mb-2"><a href="javascript:void(0);">Digital Dreamscape</a></p>
                                                    <div class="d-flex flex-wrap align-itesm-center justify-content-between mb-4">
                                                        <div class="fw-semibold">
                                                            Highest Bid -
                                                        </div>
                                                        <div class="d-flex flex-wrap align-items-center lh-1">
                                                            <span class="avatar avatar-xs me-1">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/square-color/Ethereum.svg" alt="">
                                                            </span>0.24ETH
                                                        </div>
                                                    </div>
                                                    <div class="d-grid">
                                                        <button type="button" class="btn btn-primary-light btn-wave waves-effect waves-light">Place Bid</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xxl-2 col-xl-3 col-lg-4 col-md-4 col-sm-6 col-12">
                                            <div class="card custom-card">
                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/20.png" class="card-img-top" alt="...">
                                                <div class="d-flex align-items-center justify-content-between nft-like-section w-100 px-3">
                                                    <div class="flex-fill">
                                                        <button type="button" aria-label="button" class="btn btn-sm btn-icon btn-success rounded-pill btn-wave waves-effect waves-light">
                                                            <i class="ri-heart-fill"></i>
                                                        </button>
                                                    </div>
                                                    <div>
                                                        <span class="badge nft-like-badge text-fixed-white"><i class="ri-heart-fill me-1 text-danger align-middle d-inline-block"></i>2.05k</span>
                                                    </div>
                                                </div>
                                                <div class="card-body">
                                                    <div class="d-flex align-items-center mb-3">
                                                        <div class="me-2 lh-1">
                                                            <span class="avatar avatar-rounded avatar-md">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/3.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <p class="mb-0 fw-semibold">BitMaster</p>
                                                            <p class="fs-12 text-muted mb-0">@bit_master</p>
                                                        </div>
                                                    </div>
                                                    <p class="mb-0 text-fixed-white nft-auction-time">
                                                        04hrs : 24m : 38s
                                                    </p>
                                                    <p class="fs-15 fw-semibold mb-2"><a href="javascript:void(0);">Chromatic Chaos</a></p>
                                                    <div class="d-flex flex-wrap align-itesm-center justify-content-between mb-4">
                                                        <div class="fw-semibold">
                                                            Highest Bid -
                                                        </div>
                                                        <div class="d-flex flex-wrap align-items-center lh-1">
                                                            <span class="avatar avatar-xs me-1">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/square-color/Ethereum.svg" alt="">
                                                            </span>0.19ETH
                                                        </div>
                                                    </div>
                                                    <div class="d-grid">
                                                        <button type="button" class="btn btn-primary-light btn-wave waves-effect waves-light">Place Bid</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane p-0" id="nft-domain" role="tabpanel">
                                    <div class="row">
                                        <div class="col-xxl-2 col-xl-3 col-lg-4 col-md-4 col-sm-6 col-12">
                                            <div class="card custom-card">
                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/18.png" class="card-img-top" alt="...">
                                                <div class="d-flex align-items-center justify-content-between nft-like-section w-100 px-3">
                                                    <div class="flex-fill">
                                                        <button type="button" aria-label="button" class="btn btn-sm btn-icon btn-success rounded-pill btn-wave waves-effect waves-light">
                                                            <i class="ri-heart-fill"></i>
                                                        </button>
                                                    </div>
                                                    <div>
                                                        <span class="badge nft-like-badge text-fixed-white"><i class="ri-heart-fill me-1 text-danger align-middle d-inline-block"></i>0.47k</span>
                                                    </div>
                                                </div>
                                                <div class="card-body">
                                                    <div class="d-flex align-items-center mb-3">
                                                        <div class="me-2 lh-1">
                                                            <span class="avatar avatar-rounded avatar-md">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/1.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <p class="mb-0 fw-semibold">NFTNinja</p>
                                                            <p class="fs-12 text-muted mb-0">@nftninja</p>
                                                        </div>
                                                    </div>
                                                    <p class="mb-0 text-fixed-white nft-auction-time">
                                                        04hrs : 24m : 38s
                                                    </p>
                                                    <p class="fs-15 fw-semibold mb-2"><a href="javascript:void(0);">Digital Dreamscape</a></p>
                                                    <div class="d-flex flex-wrap align-itesm-center justify-content-between mb-4">
                                                        <div class="fw-semibold">
                                                            Highest Bid -
                                                        </div>
                                                        <div class="d-flex flex-wrap align-items-center lh-1">
                                                            <span class="avatar avatar-xs me-1">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/square-color/Ethereum.svg" alt="">
                                                            </span>0.24ETH
                                                        </div>
                                                    </div>
                                                    <div class="d-grid">
                                                        <button type="button" class="btn btn-primary-light btn-wave waves-effect waves-light">Place Bid</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane p-0" id="nft-music" role="tabpanel">
                                    <div class="row">
                                        <div class="col-xxl-2 col-xl-3 col-lg-4 col-md-4 col-sm-6 col-12">
                                            <div class="card custom-card">
                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/18.png" class="card-img-top" alt="...">
                                                <div class="d-flex align-items-center justify-content-between nft-like-section w-100 px-3">
                                                    <div class="flex-fill">
                                                        <button type="button" aria-label="button" class="btn btn-sm btn-icon btn-success rounded-pill btn-wave waves-effect waves-light">
                                                            <i class="ri-heart-fill"></i>
                                                        </button>
                                                    </div>
                                                    <div>
                                                        <span class="badge nft-like-badge text-fixed-white"><i class="ri-heart-fill me-1 text-danger align-middle d-inline-block"></i>0.47k</span>
                                                    </div>
                                                </div>
                                                <div class="card-body">
                                                    <div class="d-flex align-items-center mb-3">
                                                        <div class="me-2 lh-1">
                                                            <span class="avatar avatar-rounded avatar-md">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/1.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <p class="mb-0 fw-semibold">NFTNinja</p>
                                                            <p class="fs-12 text-muted mb-0">@nftninja</p>
                                                        </div>
                                                    </div>
                                                    <p class="mb-0 text-fixed-white nft-auction-time">
                                                        04hrs : 24m : 38s
                                                    </p>
                                                    <p class="fs-15 fw-semibold mb-2"><a href="javascript:void(0);">Digital Dreamscape</a></p>
                                                    <div class="d-flex flex-wrap align-itesm-center justify-content-between mb-4">
                                                        <div class="fw-semibold">
                                                            Highest Bid -
                                                        </div>
                                                        <div class="d-flex flex-wrap align-items-center lh-1">
                                                            <span class="avatar avatar-xs me-1">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/square-color/Ethereum.svg" alt="">
                                                            </span>0.24ETH
                                                        </div>
                                                    </div>
                                                    <div class="d-grid">
                                                        <button type="button" class="btn btn-primary-light btn-wave waves-effect waves-light">Place Bid</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane p-0" id="nft-realestate" role="tabpanel">
                                    <div class="row">
                                        <div class="col-xxl-2 col-xl-3 col-lg-4 col-md-4 col-sm-6 col-12">
                                            <div class="card custom-card">
                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/18.png" class="card-img-top" alt="...">
                                                <div class="d-flex align-items-center justify-content-between nft-like-section w-100 px-3">
                                                    <div class="flex-fill">
                                                        <button type="button" aria-label="button" class="btn btn-sm btn-icon btn-success rounded-pill btn-wave waves-effect waves-light">
                                                            <i class="ri-heart-fill"></i>
                                                        </button>
                                                    </div>
                                                    <div>
                                                        <span class="badge nft-like-badge text-fixed-white"><i class="ri-heart-fill me-1 text-danger align-middle d-inline-block"></i>0.47k</span>
                                                    </div>
                                                </div>
                                                <div class="card-body">
                                                    <div class="d-flex align-items-center mb-3">
                                                        <div class="me-2 lh-1">
                                                            <span class="avatar avatar-rounded avatar-md">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/1.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <p class="mb-0 fw-semibold">NFTNinja</p>
                                                            <p class="fs-12 text-muted mb-0">@nftninja</p>
                                                        </div>
                                                    </div>
                                                    <p class="mb-0 text-fixed-white nft-auction-time">
                                                        04hrs : 24m : 38s
                                                    </p>
                                                    <p class="fs-15 fw-semibold mb-2"><a href="javascript:void(0);">Digital Dreamscape</a></p>
                                                    <div class="d-flex flex-wrap align-itesm-center justify-content-between mb-4">
                                                        <div class="fw-semibold">
                                                            Highest Bid -
                                                        </div>
                                                        <div class="d-flex flex-wrap align-items-center lh-1">
                                                            <span class="avatar avatar-xs me-1">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/square-color/Ethereum.svg" alt="">
                                                            </span>0.24ETH
                                                        </div>
                                                    </div>
                                                    <div class="d-grid">
                                                        <button type="button" class="btn btn-primary-light btn-wave waves-effect waves-light">Place Bid</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane p-0" id="nft-sports" role="tabpanel">
                                    <div class="row">
                                        <div class="col-xxl-2 col-xl-3 col-lg-4 col-md-4 col-sm-6 col-12">
                                            <div class="card custom-card">
                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/18.png" class="card-img-top" alt="...">
                                                <div class="d-flex align-items-center justify-content-between nft-like-section w-100 px-3">
                                                    <div class="flex-fill">
                                                        <button type="button" aria-label="button" class="btn btn-sm btn-icon btn-success rounded-pill btn-wave waves-effect waves-light">
                                                            <i class="ri-heart-fill"></i>
                                                        </button>
                                                    </div>
                                                    <div>
                                                        <span class="badge nft-like-badge text-fixed-white"><i class="ri-heart-fill me-1 text-danger align-middle d-inline-block"></i>0.47k</span>
                                                    </div>
                                                </div>
                                                <div class="card-body">
                                                    <div class="d-flex align-items-center mb-3">
                                                        <div class="me-2 lh-1">
                                                            <span class="avatar avatar-rounded avatar-md">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/1.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <p class="mb-0 fw-semibold">NFTNinja</p>
                                                            <p class="fs-12 text-muted mb-0">@nftninja</p>
                                                        </div>
                                                    </div>
                                                    <p class="mb-0 text-fixed-white nft-auction-time">
                                                        04hrs : 24m : 38s
                                                    </p>
                                                    <p class="fs-15 fw-semibold mb-2"><a href="javascript:void(0);">Digital Dreamscape</a></p>
                                                    <div class="d-flex flex-wrap align-itesm-center justify-content-between mb-4">
                                                        <div class="fw-semibold">
                                                            Highest Bid -
                                                        </div>
                                                        <div class="d-flex flex-wrap align-items-center lh-1">
                                                            <span class="avatar avatar-xs me-1">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/square-color/Ethereum.svg" alt="">
                                                            </span>0.24ETH
                                                        </div>
                                                    </div>
                                                    <div class="d-grid">
                                                        <button type="button" class="btn btn-primary-light btn-wave waves-effect waves-light">Place Bid</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane p-0" id="nft-fashion" role="tabpanel">
                                    <div class="row">
                                        <div class="col-xxl-2 col-xl-3 col-lg-4 col-md-4 col-sm-6 col-12">
                                            <div class="card custom-card">
                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/18.png" class="card-img-top" alt="...">
                                                <div class="d-flex align-items-center justify-content-between nft-like-section w-100 px-3">
                                                    <div class="flex-fill">
                                                        <button type="button" aria-label="button" class="btn btn-sm btn-icon btn-success rounded-pill btn-wave waves-effect waves-light">
                                                            <i class="ri-heart-fill"></i>
                                                        </button>
                                                    </div>
                                                    <div>
                                                        <span class="badge nft-like-badge text-fixed-white"><i class="ri-heart-fill me-1 text-danger align-middle d-inline-block"></i>0.47k</span>
                                                    </div>
                                                </div>
                                                <div class="card-body">
                                                    <div class="d-flex align-items-center mb-3">
                                                        <div class="me-2 lh-1">
                                                            <span class="avatar avatar-rounded avatar-md">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/1.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <p class="mb-0 fw-semibold">NFTNinja</p>
                                                            <p class="fs-12 text-muted mb-0">@nftninja</p>
                                                        </div>
                                                    </div>
                                                    <p class="mb-0 text-fixed-white nft-auction-time">
                                                        04hrs : 24m : 38s
                                                    </p>
                                                    <p class="fs-15 fw-semibold mb-2"><a href="javascript:void(0);">Digital Dreamscape</a></p>
                                                    <div class="d-flex flex-wrap align-itesm-center justify-content-between mb-4">
                                                        <div class="fw-semibold">
                                                            Highest Bid -
                                                        </div>
                                                        <div class="d-flex flex-wrap align-items-center lh-1">
                                                            <span class="avatar avatar-xs me-1">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/square-color/Ethereum.svg" alt="">
                                                            </span>0.24ETH
                                                        </div>
                                                    </div>
                                                    <div class="d-grid">
                                                        <button type="button" class="btn btn-primary-light btn-wave waves-effect waves-light">Place Bid</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane p-0" id="nft-avatars" role="tabpanel">
                                    <div class="row">
                                        <div class="col-xxl-2 col-xl-3 col-lg-4 col-md-4 col-sm-6 col-12">
                                            <div class="card custom-card">
                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/18.png" class="card-img-top" alt="...">
                                                <div class="d-flex align-items-center justify-content-between nft-like-section w-100 px-3">
                                                    <div class="flex-fill">
                                                        <button type="button" aria-label="button" class="btn btn-sm btn-icon btn-success rounded-pill btn-wave waves-effect waves-light">
                                                            <i class="ri-heart-fill"></i>
                                                        </button>
                                                    </div>
                                                    <div>
                                                        <span class="badge nft-like-badge text-fixed-white"><i class="ri-heart-fill me-1 text-danger align-middle d-inline-block"></i>0.47k</span>
                                                    </div>
                                                </div>
                                                <div class="card-body">
                                                    <div class="d-flex align-items-center mb-3">
                                                        <div class="me-2 lh-1">
                                                            <span class="avatar avatar-rounded avatar-md">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/1.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <p class="mb-0 fw-semibold">NFTNinja</p>
                                                            <p class="fs-12 text-muted mb-0">@nftninja</p>
                                                        </div>
                                                    </div>
                                                    <p class="mb-0 text-fixed-white nft-auction-time">
                                                        04hrs : 24m : 38s
                                                    </p>
                                                    <p class="fs-15 fw-semibold mb-2"><a href="javascript:void(0);">Digital Dreamscape</a></p>
                                                    <div class="d-flex flex-wrap align-itesm-center justify-content-between mb-4">
                                                        <div class="fw-semibold">
                                                            Highest Bid -
                                                        </div>
                                                        <div class="d-flex flex-wrap align-items-center lh-1">
                                                            <span class="avatar avatar-xs me-1">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/square-color/Ethereum.svg" alt="">
                                                            </span>0.24ETH
                                                        </div>
                                                    </div>
                                                    <div class="d-grid">
                                                        <button type="button" class="btn btn-primary-light btn-wave waves-effect waves-light">Place Bid</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane p-0" id="nft-memes" role="tabpanel">
                                    <div class="row">
                                        <div class="col-xxl-2 col-xl-3 col-lg-4 col-md-4 col-sm-6 col-12">
                                            <div class="card custom-card">
                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/18.png" class="card-img-top" alt="...">
                                                <div class="d-flex align-items-center justify-content-between nft-like-section w-100 px-3">
                                                    <div class="flex-fill">
                                                        <button type="button" aria-label="button" class="btn btn-sm btn-icon btn-success rounded-pill btn-wave waves-effect waves-light">
                                                            <i class="ri-heart-fill"></i>
                                                        </button>
                                                    </div>
                                                    <div>
                                                        <span class="badge nft-like-badge text-fixed-white"><i class="ri-heart-fill me-1 text-danger align-middle d-inline-block"></i>0.47k</span>
                                                    </div>
                                                </div>
                                                <div class="card-body">
                                                    <div class="d-flex align-items-center mb-3">
                                                        <div class="me-2 lh-1">
                                                            <span class="avatar avatar-rounded avatar-md">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/1.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <p class="mb-0 fw-semibold">NFTNinja</p>
                                                            <p class="fs-12 text-muted mb-0">@nftninja</p>
                                                        </div>
                                                    </div>
                                                    <p class="mb-0 text-fixed-white nft-auction-time">
                                                        04hrs : 24m : 38s
                                                    </p>
                                                    <p class="fs-15 fw-semibold mb-2"><a href="javascript:void(0);">Digital Dreamscape</a></p>
                                                    <div class="d-flex flex-wrap align-itesm-center justify-content-between mb-4">
                                                        <div class="fw-semibold">
                                                            Highest Bid -
                                                        </div>
                                                        <div class="d-flex flex-wrap align-items-center lh-1">
                                                            <span class="avatar avatar-xs me-1">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/square-color/Ethereum.svg" alt="">
                                                            </span>0.24ETH
                                                        </div>
                                                    </div>
                                                    <div class="d-grid">
                                                        <button type="button" class="btn btn-primary-light btn-wave waves-effect waves-light">Place Bid</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End:: row-2 -->

                </div>

<?php $content = ob_get_clean(); ?>
<!-- This code is useful for content -->

<!-- This code is useful for internal scripts  -->
<?php ob_start(); ?>


<?php $scripts = ob_get_clean(); ?>
<!-- This code is useful for internal scripts  -->

<!-- This code use for render base file -->
<?php include 'layouts/base.php'; ?>
<!-- This code use for render base file -->